<?php

namespace App\Services\Gateway\swagger;

use App\Models\Deposit;
use App\Models\Fund;
use Facades\App\Services\BasicCurl;
use Facades\App\Services\BasicService;

class Payment
{
	public static function prepareData($deposit, $gateway)
	{
		$val['account'] = $gateway->parameters->MAGUA_PAY_ACCOUNT;
		$val['order_id'] = $deposit->utr;
		$val['amount'] = (int)round($deposit->payable_amount);
		$val['currency'] = $deposit->payment_method_currency;
		$val['recurrent'] = false;
		$val['purpose'] = "Online Payment";
		$val['customer_first_name'] = str_replace('.', '', optional($deposit->receiver)->username) ?? "John";
		$val['customer_last_name'] = optional($deposit->receiver)->username ?? "Doe";
		$val['customer_address'] = optional($deposit->receiver->profile)->address ?? "10 Downing Street";
		$val['customer_city'] = optional($deposit->receiver->profile)->city ?? "London";
		$val['customer_zip_code'] = "121165";
		$val['customer_country'] = "GB";
		$val['customer_phone'] = optional($deposit->receiver->profile)->phone ?? "+79000000000";
		$val['customer_email'] = optional($deposit->receiver)->email ?? "johndoe@mail.com";

		$val['customer_ip_address'] = request()->ip();
		$val['merchant_site'] = url('/');

		$val['success_url'] = route('success');
		$val['fail_url'] = route('failed');
		$val['callback_url'] = route('ipn', $gateway->code);
		$val['status_url'] = route('ipn', $gateway->code);

		$url = "https://api-gateway.magua-pay.com/initPayment";
		$header = array();
		$header[] = 'Content-Type: application/json';
		$header[] = 'Authorization: Basic ' . base64_encode($gateway->parameters->MerchantKey . ":" . $gateway->parameters->Secret);

		$response = BasicCurl::curlPostRequestWithHeaders($url, $header, $val);

		$response = json_decode($response);

		if (isset($response->form_url)) {
			$send['redirect'] = true;
			$send['redirect_url'] = $response->form_url;
		} else {
			$send['error'] = true;
			$send['message'] = "Invalid Request";
		}
		return json_encode($send);

	}

	public static function ipn($request, $gateway, $deposit = null, $trx = null, $type = null)
	{
		$deposit = Deposit::where('utr', $request->orderId)->orderBy('id', 'DESC')->first();
		if ($deposit) {
			if ($request->status == 2 && $request->currency == $deposit->payment_method_currency && ($request->amount == (int)round($deposit->payable_amount)) && $deposit->status == 0) {
				BasicService::prepareOrderUpgradation($deposit);
			}
		}
	}
}
