<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class EmailTemplateSeeder extends Seeder
{
	/**
	 * Run the database seeds.
	 *
	 * @return void
	 */
	public function run()
	{
		$emailTemplates = [
			[
				'language_id' => 1,
				'template_key' => 'TRANSFER_TO',
				'email_from' => 'support@binary.com',
				'name' => 'Send money to',
				'subject' => 'Your Account has been credited',
				'template' => '[[sender]] send money to your account amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'sms_body' => '[[sender]] send money to your account amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'short_keys' => '{"sender":"Sender Name","amount":"Received Amount","currency":"Transfer Currency","transaction":"Transaction Number"}',
				'mail_status' => 1,
				'sms_status' => 1,
				'lang_code' => 'en',
			],
			[
				'language_id' => 1,
				'template_key' => 'TRANSFER_FROM',
				'email_from' => 'support@binary.com',
				'name' => 'Send money from',
				'subject' => 'Your Account has been debited',
				'template' => 'You have send money to [[receiver]] account amount [[amount]] [[currency]].Transaction: #[[transaction]]',
				'sms_body' => 'You have send money to [[receiver]] account amount [[amount]] [[currency]].Transaction: #[[transaction]]',
				'short_keys' => '{"receiver":"Receiver Name","amount":"Send Amount","currency":"Transfer Currency","transaction":"Transaction Number"}',
				'mail_status' => 1,
				'sms_status' => 1,
				'lang_code' => 'en',
			],
			[
				'language_id' => 1,
				'template_key' => 'REQUEST_MONEY_INIT',
				'email_from' => 'support@binary.com',
				'name' => 'Request Money Initialise',
				'subject' => 'Request to send money',
				'template' => '[[sender]] request for send money to account amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'sms_body' => '[[sender]] request for send money to account amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'short_keys' => '{"sender":"Sender Name","amount":"Request Amount","currency":"Request Currency","transaction":"Transaction Number"}',
				'mail_status' => 1,
				'sms_status' => 1,
				'lang_code' => 'en',
			],
			[
				'language_id' => 1,
				'template_key' => 'REQUEST_MONEY_CONFIRM',
				'email_from' => 'support@binary.com',
				'name' => 'Request Money Confirm',
				'subject' => 'Request to send money',
				'template' => '[[sender]] confirm your request money amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'sms_body' => '[[sender]] confirm your request money amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'short_keys' => '{"sender":"Sender Name","amount":"Request Amount","currency":"Request Currency","transaction":"Transaction Number"}',
				'mail_status' => 1,
				'sms_status' => 1,
				'lang_code' => 'en',
			],
			[
				'language_id' => 1,
				'template_key' => 'REQUEST_MONEY_CANCEL',
				'email_from' => 'support@binary.com',
				'name' => 'Request Money Cancel',
				'subject' => 'Request to send money',
				'template' => '[[sender]] cancel your request money amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'sms_body' => '[[sender]] cancel your request money amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'short_keys' => '{"sender":"Sender Name","amount":"Request Amount","currency":"Request Currency","transaction":"Transaction Number"}',
				'mail_status' => 1,
				'sms_status' => 1,
				'lang_code' => 'en',
			],
			[
				'language_id' => 1,
				'template_key' => 'MONEY_EXCHANGE',
				'email_from' => 'support@binary.com',
				'name' => 'Money Exchange',
				'subject' => 'Exchange Money',
				'template' => 'You are exchange [[from_amount]] [[from_currency]] to [[to_amount]] [[to_currency]]. Transaction: #[[transaction]]',
				'sms_body' => 'You are exchange [[from_amount]] [[from_currency]] to [[to_amount]] [[to_currency]]. Transaction: #[[transaction]]',
				'short_keys' => '{"from_amount":"Amount Exchange From","from_currency":"Currency Exchange From","to_amount":"Amount Exchange To","to_currency":"Currency Exchange To","transaction":"Transaction Number"}',
				'mail_status' => 1,
				'sms_status' => 1,
				'lang_code' => 'en',
			],
			[
				'language_id' => 1,
				'template_key' => 'REDEEM_CODE_GENERATE',
				'email_from' => 'support@binary.com',
				'name' => 'Redeem Code Generate',
				'subject' => 'Redeem Code Generate',
				'template' => 'You have generate a redeem code amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'sms_body' => 'You have generate a redeem code amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'short_keys' => '{"amount":"Request Amount","currency":"Request Currency","transaction":"Redeem Code"}',
				'mail_status' => 1,
				'sms_status' => 1,
				'lang_code' => 'en',
			],
			[
				'language_id' => 1,
				'template_key' => 'REDEEM_CODE_USED_BY',
				'email_from' => 'support@binary.com',
				'name' => 'Redeem code used by',
				'subject' => 'Redeem Code Used',
				'template' => 'You have used a redeem code amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'sms_body' => 'You have used a redeem code amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'short_keys' => '{"amount":"Request Amount","currency":"Request Currency","transaction":"Redeem Code"}',
				'mail_status' => 1,
				'sms_status' => 1,
				'lang_code' => 'en',
			],
			[
				'language_id' => 1,
				'template_key' => 'REDEEM_CODE_SENDER',
				'email_from' => 'support@binary.com',
				'name' => 'Redeem Code Sender',
				'subject' => 'Redeem Code Used',
				'template' => '[[receiver]] used your redeem code amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'sms_body' => '[[receiver]] used your redeem code amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'short_keys' => '{"receiver":"Receiver Name who used code","amount":"Request Amount","currency":"Request Currency","transaction":"Transaction Number"}',
				'mail_status' => 1,
				'sms_status' => 1,
				'lang_code' => 'en',
			],
			[
				'language_id' => 1,
				'template_key' => 'ESCROW_REQUEST_SENDER',
				'email_from' => 'support@binary.com',
				'name' => 'Escrow request sender',
				'subject' => 'Escrow request initiated',
				'template' => 'Your escrow request to [[receiver]] amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'sms_body' => 'Your escrow request to [[receiver]] amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'short_keys' => '{"receiver":"Receiver Name","amount":"Request Amount","currency":"Request Currency","transaction":"Transaction Number"}',
				'mail_status' => 1,
				'sms_status' => 1,
				'lang_code' => 'en',
			],
			[
				'language_id' => 1,
				'template_key' => 'ESCROW_REQUEST_RECEIVER',
				'email_from' => 'support@binary.com',
				'name' => 'Escrow request receiver',
				'subject' => 'Escrow request generated',
				'template' => 'You have escrow request from [[sender]] amount [[amount]] [[currency]] . Transaction: #[[transaction]] click to view [[link]]',
				'sms_body' => 'You have escrow request from [[sender]] amount [[amount]] [[currency]] . Transaction: #[[transaction]] click to view [[link]]',
				'short_keys' => '{"sender":"Sender Name","amount":"Request Amount","currency":"Request Currency","transaction":"Transaction Number","link":"Action Link"}',
				'mail_status' => 1,
				'sms_status' => 1,
				'lang_code' => 'en',
			],
			[
				'language_id' => 1,
				'template_key' => 'ESCROW_REQUEST_ACCEPT_FROM',
				'email_from' => 'support@binary.com',
				'name' => 'Escrow Request Accept from',
				'subject' => 'Escrow Request Accept from',
				'template' => '[[sender]] accept your request amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'sms_body' => '[[sender]] accept your request amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'short_keys' => '{"sender":"Request sender Name","amount":"Request Amount","currency":"Request Currency","transaction":"Transaction Number"}',
				'mail_status' => 1,
				'sms_status' => 1,
				'lang_code' => 'en',
			],
			[
				'language_id' => 1,
				'template_key' => 'ESCROW_REQUEST_ACCEPT_BY',
				'email_from' => 'support@binary.com',
				'name' => 'Escrow Request Accept by',
				'subject' => 'Escrow Request Accept by you',
				'template' => 'You accept escrow request amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'sms_body' => 'You accept escrow request amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'short_keys' => '{"amount":"Request Amount","currency":"Request Currency","transaction":"Transaction Number"}',
				'mail_status' => 1,
				'sms_status' => 1,
				'lang_code' => 'en',
			],
			[
				'language_id' => 1,
				'template_key' => 'ESCROW_REQUEST_CANCEL_FROM',
				'email_from' => 'support@binary.com',
				'name' => 'Escrow Request Cancel from',
				'subject' => 'Escrow Request Cancel from',
				'template' => '[[sender]] Cancel your request amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'sms_body' => '[[sender]] Cancel your request amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'short_keys' => '{"sender":"Request sender Name","amount":"Request Amount","currency":"Request Currency","transaction":"Transaction Number"}',
				'mail_status' => 1,
				'sms_status' => 1,
				'lang_code' => 'en',
			],
			[
				'language_id' => 1,
				'template_key' => 'ESCROW_REQUEST_CANCEL_BY',
				'email_from' => 'support@binary.com',
				'name' => 'Escrow Request Cancel by',
				'subject' => 'Escrow Request Cancel by you',
				'template' => 'You Cancel escrow request amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'sms_body' => 'You Cancel escrow request amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'short_keys' => '{"amount":"Request Amount","currency":"Request Currency","transaction":"Transaction Number"}',
				'mail_status' => 1,
				'sms_status' => 1,
				'lang_code' => 'en',
			],
			[
				'language_id' => 1,
				'template_key' => 'ESCROW_PAYMENT_DISBURSED_REQUEST_FROM',
				'email_from' => 'support@binary.com',
				'name' => 'Escrow payment disburse request from',
				'subject' => 'Escrow payment disburse request from',
				'template' => '[[sender]] request to disburse your amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'sms_body' => '[[sender]] request to disburse your amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'short_keys' => '{"sender":"Request sender Name","amount":"Request Amount","currency":"Request Currency","transaction":"Transaction Number"}',
				'mail_status' => 1,
				'sms_status' => 1,
				'lang_code' => 'en',
			],
			[
				'language_id' => 1,
				'template_key' => 'ESCROW_PAYMENT_DISBURSED_REQUEST_BY',
				'email_from' => 'support@binary.com',
				'name' => 'request to payment disburse request by',
				'subject' => 'Escrow payment disburse request by you',
				'template' => 'You request escrow disburse amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'sms_body' => 'You request escrow disburse amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'short_keys' => '{"amount":"Request Amount","currency":"Request Currency","transaction":"Transaction Number"}',
				'mail_status' => 1,
				'sms_status' => 1,
				'lang_code' => 'en',
			],
			[
				'language_id' => 1,
				'template_key' => 'ESCROW_PAYMENT_DISBURSED_FROM',
				'email_from' => 'support@binary.com',
				'name' => 'Escrow payment disburse from',
				'subject' => 'Escrow payment disburse from',
				'template' => '[[sender]] disburse your request amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'sms_body' => '[[sender]] disburse your request amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'short_keys' => '{"sender":"Request sender Name","amount":"Request Amount","currency":"Request Currency","transaction":"Transaction Number"}',
				'mail_status' => 1,
				'sms_status' => 1,
				'lang_code' => 'en',
			],
			[
				'language_id' => 1,
				'template_key' => 'ESCROW_PAYMENT_DISBURSED_BY',
				'email_from' => 'support@binary.com',
				'name' => 'request to payment disburse by',
				'subject' => 'Escrow payment disburse by you',
				'template' => 'You disburse escrow request amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'sms_body' => 'You disburse escrow request amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'short_keys' => '{"amount":"Request Amount","currency":"Request Currency","transaction":"Transaction Number"}',
				'mail_status' => 1,
				'sms_status' => 1,
				'lang_code' => 'en',
			],
			[
				'language_id' => 1,
				'template_key' => 'DISPUTE_REQUEST_TO_ADMIN',
				'email_from' => 'support@binary.com',
				'name' => 'Dispute request to admin',
				'subject' => 'Dispute request to admin',
				'template' => '[[sender]] dispute escrow request amount [[amount]] [[currency]] . Transaction: #[[transaction]] click to reply [[link]]',
				'sms_body' => '[[sender]] dispute escrow request amount [[amount]] [[currency]] . Transaction: #[[transaction]] click to reply [[link]]',
				'short_keys' => '{"sender":"Sender Name","amount":"Request Amount","currency":"Request Currency","transaction":"Transaction Number","link":"Dispute reply link"}',
				'mail_status' => 1,
				'sms_status' => 1,
				'lang_code' => 'en',
			],
			[
				'language_id' => 1,
				'template_key' => 'DISPUTE_REQUEST_TO_USER',
				'email_from' => 'support@binary.com',
				'name' => 'Dispute request to user',
				'subject' => 'Dispute request to user',
				'template' => '[[sender]] reply dispute escrow request amount. Transaction: #[[transaction]] click to reply [[link]]',
				'sms_body' => '[[sender]] reply dispute escrow request amount. Transaction: #[[transaction]] click to reply [[link]]',
				'short_keys' => '{"sender":"Sender Name","transaction":"Transaction Number","link":"Dispute reply link"}',
				'mail_status' => 1,
				'sms_status' => 1,
				'lang_code' => 'en',
			],
			[
				'language_id' => 1,
				'template_key' => 'VOUCHER_PAYMENT_REQUEST_TO',
				'email_from' => 'support@binary.com',
				'name' => 'Voucher payment request to',
				'subject' => 'Voucher payment request to',
				'template' => '[[sender]] request to voucher payment amount [[amount]] [[currency]] . Transaction: #[[transaction]] click to payment [[link]]',
				'sms_body' => '[[sender]] request to voucher payment amount [[amount]] [[currency]] . Transaction: #[[transaction]] click to payment [[link]]',
				'short_keys' => '{"sender":"Sender Name","amount":"Request Amount","currency":"Request Currency","transaction":"Transaction Number","link":"Dispute reply link"}',
				'mail_status' => 1,
				'sms_status' => 1,
				'lang_code' => 'en',
			],
			[
				'language_id' => 1,
				'template_key' => 'VOUCHER_PAYMENT_REQUEST_FROM',
				'email_from' => 'support@binary.com',
				'name' => 'Voucher payment request from',
				'subject' => 'Voucher payment request from',
				'template' => 'You request to [[receiver]] voucher payment amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'sms_body' => 'You request to [[receiver]] voucher payment amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'short_keys' => '{"receiver":"Receiver Name","amount":"Request Amount","currency":"Request Currency","transaction":"Transaction Number"}',
				'mail_status' => 1,
				'sms_status' => 1,
				'lang_code' => 'en',
			],
			[
				'language_id' => 1,
				'template_key' => 'VOUCHER_PAYMENT_TO',
				'email_from' => 'support@binary.com',
				'name' => 'Voucher payment to',
				'subject' => 'Voucher payment to',
				'template' => '[[receiver]] payment to your voucher amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'sms_body' => '[[receiver]] payment to your voucher amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'short_keys' => '{"receiver":"Request receiver name","amount":"Request Amount","currency":"Request Currency","transaction":"Transaction Number"}',
				'mail_status' => 1,
				'sms_status' => 1,
				'lang_code' => 'en',
			],
			[
				'language_id' => 1,
				'template_key' => 'VOUCHER_PAYMENT_FROM',
				'email_from' => 'support@binary.com',
				'name' => 'Voucher payment from',
				'subject' => 'Voucher payment from',
				'template' => 'You payment to [[sender]] voucher amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'sms_body' => 'You payment to [[sender]] voucher amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'short_keys' => '{"sender":"Request sender Name","amount":"Request Amount","currency":"Request Currency","transaction":"Transaction Number"}',
				'mail_status' => 1,
				'sms_status' => 1,
				'lang_code' => 'en',
			],
			[
				'language_id' => 1,
				'template_key' => 'VOUCHER_PAYMENT_CANCEL_TO',
				'email_from' => 'support@binary.com',
				'name' => 'Voucher payment cancel to',
				'subject' => 'Voucher payment cancel to',
				'template' => '[[receiver]] payment cancel to your voucher amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'sms_body' => '[[receiver]] payment cancel to your voucher amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'short_keys' => '{"receiver":"Request receiver name","amount":"Request Amount","currency":"Request Currency","transaction":"Transaction Number"}',
				'mail_status' => 1,
				'sms_status' => 1,
				'lang_code' => 'en',
			],
			[
				'language_id' => 1,
				'template_key' => 'VOUCHER_PAYMENT_CANCEL_FROM',
				'email_from' => 'support@binary.com',
				'name' => 'Voucher payment cancel from',
				'subject' => 'Voucher payment cancel from',
				'template' => 'You payment cancel to [[sender]] voucher amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'sms_body' => 'You payment cancel to [[sender]] voucher amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'short_keys' => '{"sender":"Request sender Name","amount":"Request Amount","currency":"Request Currency","transaction":"Transaction Number"}',
				'mail_status' => 1,
				'sms_status' => 1,
				'lang_code' => 'en',
			],
			[
				'language_id' => 1,
				'template_key' => 'PAYOUT_REQUEST_TO_ADMIN',
				'email_from' => 'support@binary.com',
				'name' => 'Payout Request Admin',
				'subject' => 'Payout Request Admin',
				'template' => '[[sender]] request for payment amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'sms_body' => '[[sender]] request for payment amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'short_keys' => '{"sender":"Sender Name","amount":"Request Amount","currency":"Request Currency","transaction":"Transaction Number"}',
				'mail_status' => 1,
				'sms_status' => 1,
				'lang_code' => 'en',
			],
			[
				'language_id' => 1,
				'template_key' => 'PAYOUT_REQUEST_FROM',
				'email_from' => 'support@binary.com',
				'name' => 'Payout Request from',
				'subject' => 'Payout Request from',
				'template' => 'You request for payout amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'sms_body' => 'You request for payout amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'short_keys' => '{"amount":"Request Amount","currency":"Request Currency","transaction":"Transaction Number"}',
				'mail_status' => 1,
				'sms_status' => 1,
				'lang_code' => 'en',
			],
			[
				'language_id' => 1,
				'template_key' => 'PAYOUT_CONFIRM',
				'email_from' => 'support@binary.com',
				'name' => 'Payout Confirm',
				'subject' => 'Payout Confirm',
				'template' => '[[sender]] confirm your payout amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'sms_body' => '[[sender]] confirm your payout amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'short_keys' => '{"sender":"Sender Name","amount":"Request Amount","currency":"Request Currency","transaction":"Transaction Number"}',
				'mail_status' => 1,
				'sms_status' => 1,
				'lang_code' => 'en',
			],
			[
				'language_id' => 1,
				'template_key' => 'PAYOUT_CANCEL',
				'email_from' => 'support@binary.com',
				'name' => 'Payout Cancel',
				'subject' => 'Payout Cancel',
				'template' => '[[sender]] cancel your payout amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'sms_body' => '[[sender]] cancel your payout amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'short_keys' => '{"sender":"Sender Name","amount":"Request Amount","currency":"Request Currency","transaction":"Transaction Number"}',
				'mail_status' => 1,
				'sms_status' => 1,
				'lang_code' => 'en',
			],
			[
				'language_id' => 1,
				'email_from' => 'support@binary.com',
				'subject' => 'Add fund user',
				'name' => 'Add Fund user user',
				'template_key' => 'ADD_FUND_USER_USER',
				'short_keys' => '{"amount":"Request Amount","currency":"Request Currency","transaction":"Transaction Number"}',
				'template' => 'you add fund money amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'sms_body' => 'you add fund money amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'mail_status' => 1,
				'sms_status' => 1,
				'lang_code' => 'en',
			],
			[
				'language_id' => 1,
				'email_from' => 'support@binary.com',
				'subject' => 'Add fund by user',
				'name' => 'Add Fund user admin',
				'template_key' => 'ADD_FUND_USER_ADMIN',
				'short_keys' => '{"user":"User full name","amount":"Request Amount","currency":"Request Currency","transaction":"Transaction Number"}',
				'template' => '[[user]] add fund money amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'sms_body' => '[[user]] add fund money amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'mail_status' => 1,
				'sms_status' => 1,
				'lang_code' => 'en',
			],
			[
				'language_id' => 1,
				'email_from' => 'support@binary.com',
				'subject' => 'verify your email',
				'name' => 'Verification Code',
				'template_key' => 'VERIFICATION_CODE',
				'short_keys' => '{"code":"code"}',
				'template' => 'Your email verification code [[code]]',
				'sms_body' => 'Your sms verification code [[code]]',
				'mail_status' => 1,
				'sms_status' => 1,
				'lang_code' => 'en',
			],
			[
				'language_id' => 1,
				'email_from' => 'support@binary.com',
				'subject' => 'Deposit Bonus',
				'name' => 'Deposit Bonus',
				'template_key' => 'DEPOSIT_BONUS',
				'short_keys' => '{"sender":"Sender Name","amount":"Received Amount","currency":"Transfer Currency","transaction":"Transaction Number"}',
				'template' => 'Deposit Commission From [[sender]] amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'sms_body' => 'Deposit Commission From [[sender]] amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'mail_status' => 1,
				'sms_status' => 1,
				'lang_code' => 'en',
			],
			[
				'language_id' => 1,
				'email_from' => 'support@binary.com',
				'subject' => 'Login Bonus',
				'name' => 'Login Bonus',
				'template_key' => 'LOGIN_BONUS',
				'short_keys' => '{"sender":"Sender Name","amount":"Received Amount","currency":"Transfer Currency","transaction":"Transaction Number"}',
				'template' => 'Login Commission From [[sender]] amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'sms_body' => 'Login Commission From [[sender]] amount [[amount]] [[currency]] . Transaction: #[[transaction]]',
				'mail_status' => 1,
				'sms_status' => 1,
				'lang_code' => 'en',
			],
			[
				'language_id' => 1,
				'template_key' => 'SECURITY_PIN_RESET',
				'email_from' => 'support@binary.com',
				'name' => 'Security pin reset',
				'subject' => 'Security pin reset',
				'template' => 'Admin reset your security pin [[pin]]',
				'sms_body' => 'Admin reset your security pin [[pin]]',
				'short_keys' => '{"pin":"Reset pin"}',
				'mail_status' => 1,
				'sms_status' => 1,
				'lang_code' => 'en',
			],
			[
				'language_id' => 1,
				'template_key' => 'SECURITY_ANSWER_RESET',
				'email_from' => 'support@binary.com',
				'name' => 'Security answer reset',
				'subject' => 'Security answer reset',
				'template' => 'Admin reset your security answer [[answer]]',
				'sms_body' => 'Admin reset your security answer [[answer]]',
				'short_keys' => '{"answer":"Reset answer"}',
				'mail_status' => 1,
				'sms_status' => 1,
				'lang_code' => 'en',
			],
		];

		DB::table('email_templates')->insert($emailTemplates);
	}
}
