<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class GatewaySeeder extends Seeder
{
	/**
	 * Run the database seeds.
	 *
	 * @return void
	 */
	public function run()
	{
		$data = [
			[
				'code' => 'paypal',
				'name' => 'Paypal',
				'sort_by' => 1,
				'status' => 1,
				'parameters' => '{"cleint_id":"", "secret":""}',
				'currencies' => '{"0":{"AUD":"AUD","BRL":"BRL","CAD":"CAD","CZK":"CZK","DKK":"DKK","EUR":"EUR","HKD":"HKD","HUF":"HUF","INR":"INR","ILS":"ILS","JPY":"JPY","MYR":"MYR","MXN":"MXN","TWD":"TWD","NZD":"NZD","NOK":"NOK","PHP":"PHP","PLN":"PLN","GBP":"GBP","RUB":"RUB","SGD":"SGD","SEK":"SEK","CHF":"CHF","THB":"THB","USD":"USD"}}',
				'extra_parameters' => NULL,
				'currency' => 'USD',
				'symbol' => 'USD',
				'min_amount' => '1.00000000',
				'max_amount' => '10000.00000000',
				'percentage_charge' => '1.0000',
				'fixed_charge' => '0.50000000',
				'convention_rate' => '1.00000000',
			],
			[
				'code' => 'stripe',
				'name' => 'Stripe ',
				'sort_by' => 4,
				'status' => 1,
				'parameters' => '{"secret_key":"","publishable_key":""}',
				'currencies' => '{"0":{"USD":"USD","AUD":"AUD","BRL":"BRL","CAD":"CAD","CHF":"CHF","DKK":"DKK","EUR":"EUR","GBP":"GBP","HKD":"HKD","INR":"INR","JPY":"JPY","MXN":"MXN","MYR":"MYR","NOK":"NOK","NZD":"NZD","PLN":"PLN","SEK":"SEK","SGD":"SGD"}}',
				'extra_parameters' => NULL,
				'currency' => 'USD',
				'symbol' => 'USD',
				'min_amount' => '1.00000000',
				'max_amount' => '10000.00000000',
				'percentage_charge' => '0.0000',
				'fixed_charge' => '0.50000000',
				'convention_rate' => '1.00000000',
			],
			[
				'code' => 'skrill',
				'name' => 'Skrill',
				'sort_by' => 3,
				'status' => 1,
				'parameters' => '{"pay_to_email":"","secret_key":"SECRETKEY"}',
				'currencies' => '{"0":{"AED":"AED","AUD":"AUD","BGN":"BGN","BHD":"BHD","CAD":"CAD","CHF":"CHF","CZK":"CZK","DKK":"DKK","EUR":"EUR","GBP":"GBP","HKD":"HKD","HRK":"HRK","HUF":"HUF","ILS":"ILS","INR":"INR","ISK":"ISK","JOD":"JOD","JPY":"JPY","KRW":"KRW","KWD":"KWD","MAD":"MAD","MYR":"MYR","NOK":"NOK","NZD":"NZD","OMR":"OMR","PLN":"PLN","QAR":"QAR","RON":"RON","RSD":"RSD","SAR":"SAR","SEK":"SEK","SGD":"SGD","THB":"THB","TND":"TND","TRY":"TRY","TWD":"TWD","USD":"USD","ZAR":"ZAR","COP":"COP"}}',
				'extra_parameters' => NULL,
				'currency' => 'USD',
				'symbol' => 'USD',
				'min_amount' => '1.00000000',
				'max_amount' => '10000.00000000',
				'percentage_charge' => '0.0000',
				'fixed_charge' => '0.50000000',
				'convention_rate' => '1.00000000',
			],
			[
				'code' => 'perfectmoney',
				'name' => 'Perfect Money',
				'sort_by' => 5,
				'status' => 1,
				'parameters' => '{"passphrase":"","payee_account":""}',
				'currencies' => '{"0":{"USD":"USD","EUR":"EUR"}}',
				'extra_parameters' => NULL,
				'currency' => 'USD',
				'symbol' => 'USD',
				'min_amount' => '1.00000000',
				'max_amount' => '10000.00000000',
				'percentage_charge' => '0.0000',
				'fixed_charge' => '0.50000000',
				'convention_rate' => '1.00000000',
			],
			[
				'code' => 'paytm',
				'name' => 'PayTM',
				'sort_by' => 7,
				'status' => 1,
				'parameters' => '{"MID":"","merchant_key":"","WEBSITE":"","INDUSTRY_TYPE_ID":"","CHANNEL_ID":"","transaction_url":"":""}',
				'currencies' => '{"0":{"AUD":"AUD","ARS":"ARS","BDT":"BDT","BRL":"BRL","BGN":"BGN","CAD":"CAD","CLP":"CLP","CNY":"CNY","COP":"COP","HRK":"HRK","CZK":"CZK","DKK":"DKK","EGP":"EGP","EUR":"EUR","GEL":"GEL","GHS":"GHS","HKD":"HKD","HUF":"HUF","INR":"INR","IDR":"IDR","ILS":"ILS","JPY":"JPY","KES":"KES","MYR":"MYR","MXN":"MXN","MAD":"MAD","NPR":"NPR","NZD":"NZD","NGN":"NGN","NOK":"NOK","PKR":"PKR","PEN":"PEN","PHP":"PHP","PLN":"PLN","RON":"RON","RUB":"RUB","SGD":"SGD","ZAR":"ZAR","KRW":"KRW","LKR":"LKR","SEK":"SEK","CHF":"CHF","THB":"THB","TRY":"TRY","UGX":"UGX","UAH":"UAH","AED":"AED","GBP":"GBP","USD":"USD","VND":"VND","XOF":"XOF"}}',
				'extra_parameters' => NULL,
				'currency' => 'USD',
				'symbol' => 'USD',
				'min_amount' => '1.00000000',
				'max_amount' => '10000.00000000',
				'percentage_charge' => '0.0000',
				'fixed_charge' => '0.50000000',
				'convention_rate' => '1.00000000',
			],
			[
				'code' => 'payeer',
				'name' => 'Payeer',
				'sort_by' => 6,
				'status' => 1,
				'parameters' => '{"merchant_id":"","secret_key":""}',
				'currencies' => '{"0":{"USD":"USD","EUR":"EUR","RUB":"RUB"}}',
				'extra_parameters' => '{"status":"ipn"}',
				'currency' => 'USD',
				'symbol' => 'USD',
				'min_amount' => '1.00000000',
				'max_amount' => '10000.00000000',
				'percentage_charge' => '0.0000',
				'fixed_charge' => '0.50000000',
				'convention_rate' => '1.00000000',
			],
			[
				'code' => 'paystack',
				'name' => 'PayStack',
				'sort_by' => 8,
				'status' => 1,
				'parameters' => '{"public_key":"","secret_key":""}',
				'currencies' => '{"0":{"USD":"USD","NGN":"NGN"}}',
				'extra_parameters' => '{"callback":"ipn","webhook":"ipn"}\r\n',
				'currency' => 'NGN',
				'symbol' => 'NGN',
				'min_amount' => '1.00000000',
				'max_amount' => '10000.00000000',
				'percentage_charge' => '0.0000',
				'fixed_charge' => '0.50000000',
				'convention_rate' => '1.00000000',
			],
			[
				'code' => 'voguepay',
				'name' => 'VoguePay',
				'sort_by' => 9,
				'status' => 1,
				'parameters' => '{"merchant_id":""}',
				'currencies' => '{"0":{"NGN":"NGN","USD":"USD","EUR":"EUR","GBP":"GBP","ZAR":"ZAR","JPY":"JPY","INR":"INR","AUD":"AUD","CAD":"CAD","NZD":"NZD","NOK":"NOK","PLN":"PLN"}}\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n',
				'extra_parameters' => NULL,
				'currency' => 'USD',
				'symbol' => 'USD',
				'min_amount' => '1.00000000',
				'max_amount' => '10000.00000000',
				'percentage_charge' => '0.0000',
				'fixed_charge' => '0.50000000',
				'convention_rate' => '1.00000000',
			],
			[
				'code' => 'flutterwave',
				'name' => 'Flutterwave',
				'sort_by' => 10,
				'status' => 1,
				'parameters' => '{"public_key":"","secret_key":"","encryption_key":""}\r\n\r\n',
				'currencies' => '{"0":{"KES":"KES","GHS":"GHS","NGN":"NGN","USD":"USD","GBP":"GBP","EUR":"EUR","UGX":"UGX","TZS":"TZS"}}',
				'extra_parameters' => NULL,
				'currency' => 'USD',
				'symbol' => 'USD',
				'min_amount' => '1.00000000',
				'max_amount' => '10000.00000000',
				'percentage_charge' => '0.0000',
				'fixed_charge' => '0.50000000',
				'convention_rate' => '1.00000000',
			],
			[
				'code' => 'razorpay',
				'name' => 'RazorPay',
				'sort_by' => 11,
				'status' => 1,
				'parameters' => '{"key_id":"","key_secret":""}',
				'currencies' => '{"0":{"INR":"INR"}}',
				'extra_parameters' => NULL,
				'currency' => 'INR',
				'symbol' => 'INR',
				'min_amount' => '1.00000000',
				'max_amount' => '10000.00000000',
				'percentage_charge' => '0.0000',
				'fixed_charge' => '0.50000000',
				'convention_rate' => '1.00000000',
			],
			[
				'code' => 'instamojo',
				'name' => 'instamojo',
				'sort_by' => 12,
				'status' => 1,
				'parameters' => '{"api_key":"","auth_token":"","salt":""}',
				'currencies' => '{"0":{"INR":"INR"}}',
				'extra_parameters' => NULL,
				'currency' => 'INR',
				'symbol' => 'INR',
				'min_amount' => '1.00000000',
				'max_amount' => '10000.00000000',
				'percentage_charge' => '0.0000',
				'fixed_charge' => '0.50000000',
				'convention_rate' => '73.51000000',
			],
			[
				'code' => 'mollie',
				'name' => 'Mollie',
				'sort_by' => 13,
				'status' => 1,
				'parameters' => '{"api_key":""}',
				'currencies' => '{"0":{"AED":"AED","AUD":"AUD","BGN":"BGN","BRL":"BRL","CAD":"CAD","CHF":"CHF","CZK":"CZK","DKK":"DKK","EUR":"EUR","GBP":"GBP","HKD":"HKD","HRK":"HRK","HUF":"HUF","ILS":"ILS","ISK":"ISK","JPY":"JPY","MXN":"MXN","MYR":"MYR","NOK":"NOK","NZD":"NZD","PHP":"PHP","PLN":"PLN","RON":"RON","RUB":"RUB","SEK":"SEK","SGD":"SGD","THB":"THB","TWD":"TWD","USD":"USD","ZAR":"ZAR"}}',
				'extra_parameters' => NULL,
				'currency' => 'USD',
				'symbol' => 'USD',
				'min_amount' => '1.00000000',
				'max_amount' => '10000.00000000',
				'percentage_charge' => '0.0000',
				'fixed_charge' => '0.50000000',
				'convention_rate' => '73.51000000',
			],
			[
				'code' => 'twocheckout',
				'name' => '2checkout',
				'sort_by' => 14,
				'status' => 1,
				'parameters' => '{"merchant_code":"","secret_key":""}',
				'currencies' => '{"0":{"AFN":"AFN","ALL":"ALL","DZD":"DZD","ARS":"ARS","AUD":"AUD","AZN":"AZN","BSD":"BSD","BDT":"BDT","BBD":"BBD","BZD":"BZD","BMD":"BMD","BOB":"BOB","BWP":"BWP","BRL":"BRL","GBP":"GBP","BND":"BND","BGN":"BGN","CAD":"CAD","CLP":"CLP","CNY":"CNY","COP":"COP","CRC":"CRC","HRK":"HRK","CZK":"CZK","DKK":"DKK","DOP":"DOP","XCD":"XCD","EGP":"EGP","EUR":"EUR","FJD":"FJD","GTQ":"GTQ","HKD":"HKD","HNL":"HNL","HUF":"HUF","INR":"INR","IDR":"IDR","ILS":"ILS","JMD":"JMD","JPY":"JPY","KZT":"KZT","KES":"KES","LAK":"LAK","MMK":"MMK","LBP":"LBP","LRD":"LRD","MOP":"MOP","MYR":"MYR","MVR":"MVR","MRO":"MRO","MUR":"MUR","MXN":"MXN","MAD":"MAD","NPR":"NPR","TWD":"TWD","NZD":"NZD","NIO":"NIO","NOK":"NOK","PKR":"PKR","PGK":"PGK","PEN":"PEN","PHP":"PHP","PLN":"PLN","QAR":"QAR","RON":"RON","RUB":"RUB","WST":"WST","SAR":"SAR","SCR":"SCR","SGD":"SGD","SBD":"SBD","ZAR":"ZAR","KRW":"KRW","LKR":"LKR","SEK":"SEK","CHF":"CHF","SYP":"SYP","THB":"THB","TOP":"TOP","TTD":"TTD","TRY":"TRY","UAH":"UAH","AED":"AED","USD":"USD","VUV":"VUV","VND":"VND","XOF":"XOF","YER":"YER"}}',
				'extra_parameters' => '{"approved_url":"ipn"}',
				'currency' => 'USD',
				'symbol' => 'USD',
				'min_amount' => '1.00000000',
				'max_amount' => '10000.00000000',
				'percentage_charge' => '0.0000',
				'fixed_charge' => '0.50000000',
				'convention_rate' => '1.00000000',
			],
			[
				'code' => 'authorizenet',
				'name' => 'Authorize.Net',
				'sort_by' => 15,
				'status' => 1,
				'parameters' => '{"login_id":"","current_transaction_key":""}',
				'currencies' => '{"0":{"AUD":"AUD","CAD":"CAD","CHF":"CHF","DKK":"DKK","EUR":"EUR","GBP":"GBP","NOK":"NOK","NZD":"NZD","PLN":"PLN","SEK":"SEK","USD":"USD"}}',
				'extra_parameters' => NULL,
				'currency' => 'USD',
				'symbol' => 'USD',
				'min_amount' => '1.00000000',
				'max_amount' => '10000.00000000',
				'percentage_charge' => '0.0000',
				'fixed_charge' => '0.50000000',
				'convention_rate' => '1.00000000',
			],
			[
				'code' => 'securionpay',
				'name' => 'SecurionPay',
				'sort_by' => 16,
				'status' => 1,
				'parameters' => '{"public_key":"","secret_key":""}',
				'currencies' => '{"0":{"AFN":"AFN", "DZD":"DZD", "ARS":"ARS", "AUD":"AUD", "BHD":"BHD", "BDT":"BDT", "BYR":"BYR", "BAM":"BAM", "BWP":"BWP", "BRL":"BRL", "BND":"BND", "BGN":"BGN", "CAD":"CAD", "CLP":"CLP", "CNY":"CNY", "COP":"COP", "KMF":"KMF", "HRK":"HRK", "CZK":"CZK", "DKK":"DKK", "DJF":"DJF", "DOP":"DOP", "EGP":"EGP", "ETB":"ETB", "ERN":"ERN", "EUR":"EUR", "GEL":"GEL", "HKD":"HKD", "HUF":"HUF", "ISK":"ISK", "INR":"INR", "IDR":"IDR", "IRR":"IRR", "IQD":"IQD", "ILS":"ILS", "JMD":"JMD", "JPY":"JPY", "JOD":"JOD", "KZT":"KZT", "KES":"KES", "KWD":"KWD", "KGS":"KGS", "LVL":"LVL", "LBP":"LBP", "LTL":"LTL", "MOP":"MOP", "MKD":"MKD", "MGA":"MGA", "MWK":"MWK", "MYR":"MYR", "MUR":"MUR", "MXN":"MXN", "MDL":"MDL", "MAD":"MAD", "MZN":"MZN", "NAD":"NAD", "NPR":"NPR", "ANG":"ANG", "NZD":"NZD", "NOK":"NOK", "OMR":"OMR", "PKR":"PKR", "PEN":"PEN", "PHP":"PHP", "PLN":"PLN", "QAR":"QAR", "RON":"RON", "RUB":"RUB", "SAR":"SAR", "RSD":"RSD", "SGD":"SGD", "ZAR":"ZAR", "KRW":"KRW", "IKR":"IKR", "LKR":"LKR", "SEK":"SEK", "CHF":"CHF", "SYP":"SYP", "TWD":"TWD", "TZS":"TZS", "THB":"THB", "TND":"TND", "TRY":"TRY", "UAH":"UAH", "AED":"AED", "GBP":"GBP", "USD":"USD", "VEB":"VEB", "VEF":"VEF", "VND":"VND", "XOF":"XOF", "YER":"YER", "ZMK":"ZMK"}}',
				'extra_parameters' => NULL,
				'currency' => 'USD',
				'symbol' => 'USD',
				'min_amount' => '1.00000000',
				'max_amount' => '10000.00000000',
				'percentage_charge' => '0.0000',
				'fixed_charge' => '0.50000000',
				'convention_rate' => '1.00000000',
			],
			[
				'code' => 'payumoney',
				'name' => 'PayUmoney',
				'sort_by' => 17,
				'status' => 1,
				'parameters' => '{"merchant_key":"","salt":""}',
				'currencies' => '{"0":{"INR":"INR"}}',
				'extra_parameters' => NULL,
				'currency' => 'INR',
				'symbol' => 'INR',
				'min_amount' => '1.00000000',
				'max_amount' => '10000.00000000',
				'percentage_charge' => '0.0000',
				'fixed_charge' => '0.50000000',
				'convention_rate' => '73.51000000',
			],
			[
				'code' => 'mercadopago',
				'name' => 'Mercado Pago',
				'sort_by' => 18,
				'status' => 1,
				'parameters' => '{"access_token":""}',
				'currencies' => '{"0":{"ARS":"ARS","BOB":"BOB","BRL":"BRL","CLF":"CLF","CLP":"CLP","COP":"COP","CRC":"CRC","CUC":"CUC","CUP":"CUP","DOP":"DOP","EUR":"EUR","GTQ":"GTQ","HNL":"HNL","MXN":"MXN","NIO":"NIO","PAB":"PAB","PEN":"PEN","PYG":"PYG","USD":"USD","UYU":"UYU","VEF":"VEF","VES":"VES"}}',
				'extra_parameters' => NULL,
				'currency' => 'BRL',
				'symbol' => 'BRL',
				'min_amount' => '3715.12000000',
				'max_amount' => '371500000.12000000',
				'percentage_charge' => '0.0000',
				'fixed_charge' => '0.50000000',
				'convention_rate' => '3715.12000000',
			],
			[
				'code' => 'coingate',
				'name' => 'Coingate',
				'sort_by' => 21,
				'status' => 1,
				'parameters' => '{"api_key":""}',
				'currencies' => '{"0":{"USD":"USD","EUR":"EUR"}}',
				'extra_parameters' => NULL,
				'currency' => 'USD',
				'symbol' => 'USD',
				'min_amount' => '1.00000000',
				'max_amount' => '10000.00000000',
				'percentage_charge' => '0.0000',
				'fixed_charge' => '0.50000000',
				'convention_rate' => '1.00000000',
			],
			[
				'code' => 'coinbasecommerce',
				'name' => 'Coinbase Commerce',
				'sort_by' => 22,
				'status' => 1,
				'parameters' => '{"api_key":"","secret":""}',
				'currencies' => '{"0":{"AED":"AED","AFN":"AFN","ALL":"ALL","AMD":"AMD","ANG":"ANG","AOA":"AOA","ARS":"ARS","AUD":"AUD","AWG":"AWG","AZN":"AZN","BAM":"BAM","BBD":"BBD","BDT":"BDT","BGN":"BGN","BHD":"BHD","BIF":"BIF","BMD":"BMD","BND":"BND","BOB":"BOB","BRL":"BRL","BSD":"BSD","BTN":"BTN","BWP":"BWP","BYN":"BYN","BZD":"BZD","CAD":"CAD","CDF":"CDF","CHF":"CHF","CLF":"CLF","CLP":"CLP","CNY":"CNY","COP":"COP","CRC":"CRC","CUC":"CUC","CUP":"CUP","CVE":"CVE","CZK":"CZK","DJF":"DJF","DKK":"DKK","DOP":"DOP","DZD":"DZD","EGP":"EGP","ERN":"ERN","ETB":"ETB","EUR":"EUR","FJD":"FJD","FKP":"FKP","GBP":"GBP","GEL":"GEL","GGP":"GGP","GHS":"GHS","GIP":"GIP","GMD":"GMD","GNF":"GNF","GTQ":"GTQ","GYD":"GYD","HKD":"HKD","HNL":"HNL","HRK":"HRK","HTG":"HTG","HUF":"HUF","IDR":"IDR","ILS":"ILS","IMP":"IMP","INR":"INR","IQD":"IQD","IRR":"IRR","ISK":"ISK","JEP":"JEP","JMD":"JMD","JOD":"JOD","JPY":"JPY","KES":"KES","KGS":"KGS","KHR":"KHR","KMF":"KMF","KPW":"KPW","KRW":"KRW","KWD":"KWD","KYD":"KYD","KZT":"KZT","LAK":"LAK","LBP":"LBP","LKR":"LKR","LRD":"LRD","LSL":"LSL","LYD":"LYD","MAD":"MAD","MDL":"MDL","MGA":"MGA","MKD":"MKD","MMK":"MMK","MNT":"MNT","MOP":"MOP","MRO":"MRO","MUR":"MUR","MVR":"MVR","MWK":"MWK","MXN":"MXN","MYR":"MYR","MZN":"MZN","NAD":"NAD","NGN":"NGN","NIO":"NIO","NOK":"NOK","NPR":"NPR","NZD":"NZD","OMR":"OMR","PAB":"PAB","PEN":"PEN","PGK":"PGK","PHP":"PHP","PKR":"PKR","PLN":"PLN","PYG":"PYG","QAR":"QAR","RON":"RON","RSD":"RSD","RUB":"RUB","RWF":"RWF","SAR":"SAR","SBD":"SBD","SCR":"SCR","SDG":"SDG","SEK":"SEK","SGD":"SGD","SHP":"SHP","SLL":"SLL","SOS":"SOS","SRD":"SRD","SSP":"SSP","STD":"STD","SVC":"SVC","SYP":"SYP","SZL":"SZL","THB":"THB","TJS":"TJS","TMT":"TMT","TND":"TND","TOP":"TOP","TRY":"TRY","TTD":"TTD","TWD":"TWD","TZS":"TZS","UAH":"UAH","UGX":"UGX","USD":"USD","UYU":"UYU","UZS":"UZS","VEF":"VEF","VND":"VND","VUV":"VUV","WST":"WST","XAF":"XAF","XAG":"XAG","XAU":"XAU","XCD":"XCD","XDR":"XDR","XOF":"XOF","XPD":"XPD","XPF":"XPF","XPT":"XPT","YER":"YER","ZAR":"ZAR","ZMW":"ZMW","ZWL":"ZWL"}}',
				'extra_parameters' => NULL,
				'currency' => 'USD',
				'symbol' => 'USD',
				'min_amount' => '1.00000000',
				'max_amount' => '10000.00000000',
				'percentage_charge' => '0.0000',
				'fixed_charge' => '0.50000000',
				'convention_rate' => '1.00000000',
			],
			[
				'code' => 'monnify',
				'name' => 'Monnify',
				'sort_by' => 19,
				'status' => 1,
				'parameters' => '{"api_key":"","secret_key":"", "contract_code":""}',
				'currencies' => '{"0":{"NGN":"NGN"}}',
				'extra_parameters' => NULL,
				'currency' => 'NGN',
				'symbol' => 'NGN',
				'min_amount' => '1.00000000',
				'max_amount' => '10000.00000000',
				'percentage_charge' => '0.0000',
				'fixed_charge' => '0.50000000',
				'convention_rate' => '1.00000000',
			],
			[
				'code' => 'blockio',
				'name' => 'Block.io',
				'sort_by' => 23,
				'status' => 1,
				'parameters' => '{"api_key":"","api_pin":""}',
				'currencies' => '{"1":{"BTC":"BTC","LTC":"LTC","DOGE":"DOGE"}}',
				'extra_parameters' => '{"cron":"ipn"}',
				'currency' => 'BTC',
				'symbol' => 'BTC',
				'min_amount' => '0.00004200',
				'max_amount' => '10000.00000000',
				'percentage_charge' => '0.0000',
				'fixed_charge' => '0.50000000',
				'convention_rate' => '0.00004200',
			],
			[
				'code' => 'coinpayments',
				'name' => 'CoinPayments',
				'sort_by' => 20,
				'status' => 1,
				'parameters' => '{"merchant_id":""}',
				'currencies' => '{"0":{"USD":"USD","AUD":"AUD","BRL":"BRL","CAD":"CAD","CHF":"CHF","CLP":"CLP","CNY":"CNY","DKK":"DKK","EUR":"EUR","GBP":"GBP","HKD":"HKD","INR":"INR","ISK":"ISK","JPY":"JPY","KRW":"KRW","NZD":"NZD","PLN":"PLN","RUB":"RUB","SEK":"SEK","SGD":"SGD","THB":"THB","TWD":"TWD"},"1":{"BTC":"Bitcoin","BTC.LN":"Bitcoin (Lightning Network)","LTC":"Litecoin","CPS":"CPS Coin","VLX":"Velas","APL":"Apollo","AYA":"Aryacoin","BAD":"Badcoin","BCD":"Bitcoin Diamond","BCH":"Bitcoin Cash","BCN":"Bytecoin","BEAM":"BEAM","BITB":"Bean Cash","BLK":"BlackCoin","BSV":"Bitcoin SV","BTAD":"Bitcoin Adult","BTG":"Bitcoin Gold","BTT":"BitTorrent","CLOAK":"CloakCoin","CLUB":"ClubCoin","CRW":"Crown","CRYP":"CrypticCoin","CRYT":"CryTrExCoin","CURE":"CureCoin","DASH":"DASH","DCR":"Decred","DEV":"DeviantCoin","DGB":"DigiByte","DOGE":"Dogecoin","EBST":"eBoost","EOS":"EOS","ETC":"Ether Classic","ETH":"Ethereum","ETN":"Electroneum","EUNO":"EUNO","EXP":"EXP","Expanse":"Expanse","FLASH":"FLASH","GAME":"GameCredits","GLC":"Goldcoin","GRS":"Groestlcoin","KMD":"Komodo","LOKI":"LOKI","LSK":"LSK","MAID":"MaidSafeCoin","MUE":"MonetaryUnit","NAV":"NAV Coin","NEO":"NEO","NMC":"Namecoin","NVST":"NVO Token","NXT":"NXT","OMNI":"OMNI","PINK":"PinkCoin","PIVX":"PIVX","POT":"PotCoin","PPC":"Peercoin","PROC":"ProCurrency","PURA":"PURA","QTUM":"QTUM","RES":"Resistance","RVN":"Ravencoin","RVR":"RevolutionVR","SBD":"Steem Dollars","SMART":"SmartCash","SOXAX":"SOXAX","STEEM":"STEEM","STRAT":"STRAT","SYS":"Syscoin","TPAY":"TokenPay","TRIGGERS":"Triggers","TRX":" TRON","UBQ":"Ubiq","UNIT":"UniversalCurrency","USDT":"Tether USD (Omni Layer)","VTC":"Vertcoin","WAVES":"Waves","XCP":"Counterparty","XEM":"NEM","XMR":"Monero","XSN":"Stakenet","XSR":"SucreCoin","XVG":"VERGE","XZC":"ZCoin","ZEC":"ZCash","ZEN":"Horizen"}}',
				'extra_parameters' => NULL,
				'currency' => 'BTC',
				'symbol' => 'BTC',
				'min_amount' => '0.00004200',
				'max_amount' => '10000.00000000',
				'percentage_charge' => '0.0000',
				'fixed_charge' => '0.50000000',
				'convention_rate' => '0.00004200',
			],
			[
				'code' => 'blockchain',
				'name' => 'Blockchain',
				'sort_by' => 24,
				'status' => 1,
				'parameters' => '{"api_key":"","xpub_code":""}',
				'currencies' => '{"1":{"BTC":"BTC"}}',
				'extra_parameters' => NULL,
				'currency' => 'BTC',
				'symbol' => 'BTC',
				'min_amount' => '0.00000000',
				'max_amount' => '10000.00000000',
				'percentage_charge' => '0.0000',
				'fixed_charge' => '0.50000000',
				'convention_rate' => '0.00000000',
			],
			[
				'code' => 'cashmaal',
				'name' => 'cashmaal',
				'sort_by' => 2,
				'status' => 1,
				'parameters' => '{"web_id": "3748","ipn_key": "546254628759524554647987"}',
				'currencies' => '{"0":{"PKR":"PKR","USD":"USD"}}',
				'extra_parameters' => '{"ipn_url":"ipn"}',
				'currency' => 'PKR',
				'symbol' => 'PKR',
				'min_amount' => '1.00000000',
				'max_amount' => '100.00000000',
				'percentage_charge' => '0.0000',
				'fixed_charge' => '0.00000000',
				'convention_rate' => '1.00000000',
			],
		];

		DB::table('gateways')->insert($data);
	}
}
