<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="description" content="">
	<meta name="author" content="">
	<link rel="icon" type="image/png" sizes="16x16"
		  href="{{ getFile(config('basic.default_file_driver'),config('basic.favicon_image'))}}">
	<title>@yield('title')</title>

	<link href="{{asset('assets/admin/css/style.min.css')}}" rel="stylesheet">

	@stack('css')

</head>
<body>
<header class="topbar header-user" data-navbarbg="skin6">
	<nav class="navbar top-navbar navbar-expand-md">
		<div class="navbar-header" data-logobg="skin6">
			<!-- This is for the sidebar toggle which is visible on mobile only -->
			<a class="nav-toggler waves-effect waves-light d-block d-md-none" data-toggle="collapse"
			   data-target="#navbar-user"
			   aria-controls="navbar-user" aria-expanded="false" href="javascript:void(0)"><i
					class="ti-menu ti-close"></i></a>
			<div class="navbar-brand">
				<!-- Logo icon -->
				<a href="{{route('user.home')}}">
					<b class="logo-icon">
						<!-- Dark Logo icon -->
						<img src="{{ getFile(config('basic.default_file_driver'),config('basic.logo_image'))}}"
							 alt="homepage"
							 class="dark-logo">

						<img src="{{ getFile(config('basic.default_file_driver'),config('basic.logo_image'))}}" alt="homepage"
							 class="light-logo">
					</b>
				</a>
			</div>
			<a class="topbartoggler d-block d-md-none waves-effect waves-light" href="javascript:void(0)"
			   data-toggle="collapse" data-target="#navbarSupportedContent"
			   aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation"><i
					class="ti-more"></i></a>
		</div>
		<!-- ============================================================== -->
		<!-- End Logo -->
		<!-- ============================================================== -->

		<div class="navbar-collapse collapse" id="navbarSupportedContent">

			<ul class="navbar-nav float-left mr-auto ml-3 pl-1 d-none d-md-flex">
				<li class="nav-item {{ request()->is('user/home') ? 'active' : ''  }}">
					<a class="nav-link" href="{{ route('user.home') }}">@lang('Statistics') </a>
				</li>
			</ul>

			<ul class="navbar-nav float-right">
				<li class="nav-item d-none d-md-block">
					<a class="nav-link" href="javascript:void(0)">
						<form>
							<div class="customize-input">
								<input class="form-control custom-shadow custom-radius border-0 bg-white"
									   type="search" placeholder="Search" aria-label="Search">
								<i class="form-control-icon" data-feather="search"></i>
							</div>
						</form>
					</a>
				</li>
				<li class="nav-item dropdown">
					<a class="nav-link dropdown-toggle" href="javascript:void(0)" data-toggle="dropdown"
					   aria-haspopup="true" aria-expanded="false">
						@if(Auth::user()->image)
							<img src="{{asset('assets/uploads/users/'.Auth::user()->image )}}"
								 alt="{{ Auth::user()->name }}" class="rounded-circle" width="40px">
						@endif

						<span class="ml-2 d-none d-lg-inline-block"><span>Hello,</span> <span
								class="text-dark">{{ Auth::user()->name }}</span> <i data-feather="chevron-down"
																					 class="svg-icon"></i></span>
					</a>
					<div class="dropdown-menu dropdown-menu-right user-dd animated flipInY">
						<a class="dropdown-item" href="{{ route('logout') }}"
						   onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();"><i
								data-feather="power" class="svg-icon mr-2 ml-1"></i>
							{{ __('Logout') }}
						</a>
						<form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
							@csrf
						</form>

					</div>
				</li>
				<!-- ============================================================== -->
				<!-- User profile and search -->
				<!-- ============================================================== -->
			</ul>
		</div>

	</nav>

</header>

<div id="app">
	<nav class="navbar navbar-expand-md navbar-light bg-white shadow-sm">
		<div class="container">
			<a class="navbar-brand" href="{{ url('/') }}">
				@lang('Please Verify Your Email.')
			</a>
			<button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent"
					aria-controls="navbarSupportedContent" aria-expanded="false"
					aria-label="{{ __('Toggle navigation') }}">
				<span class="navbar-toggler-icon"></span>
			</button>

			<div class="collapse navbar-collapse" id="navbarSupportedContent">
				<!-- Left Side Of Navbar -->
				<ul class="navbar-nav mr-auto">

				</ul>

				<!-- Right Side Of Navbar -->
				<ul class="navbar-nav ml-auto">
					<!-- Authentication Links -->
					@guest
						<li class="nav-item">
							<a class="nav-link" href="{{ route('login') }}">{{ __('Login') }}</a>
						</li>
						@if (Route::has('register'))
							<li class="nav-item">
								<a class="nav-link" href="{{ route('register') }}">{{ __('Register') }}</a>
							</li>
						@endif
					@else
						<li class="nav-item dropdown">
							<a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button"
							   data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
								{{ Auth::user()->name }}
							</a>
							@lang('Before proceeding, please check your email for a verification link.')
							@lang('If you did not receive the email'),
							<form class="d-inline" method="POST" action="{{ route('verification.resend') }}">
								@csrf
								<button type="submit"
										class="btn btn-link p-0 m-0 align-baseline">{{ __('click here to request another') }}</button>
								.
							</form>

						</li>
					@endguest
				</ul>
			</div>
		</div>
	</nav>

	<main class="py-4">
		@yield('content')
	</main>
</div>


<script src="{{asset('assets/admin/js/jquery.min.js') }}"></script>
<script src="{{asset('assets/admin/js/popper.min.js') }}"></script>
<script src="{{ asset('assets/admin/js/bootstrap.min.js') }}"></script>
@stack('js-lib')
<script src="{{ asset('assets/admin/js/app-style-switcher.js') }}"></script>
<script src="{{ asset('assets/admin/js/feather.min.js') }}"></script>
<script src="{{ asset('assets/admin/js/toastr.min.js')}}"></script>
@stack('js')
@include('admin.layouts.notification')

</body>
</html>
