<!DOCTYPE html>
<html lang="en" <?php if(session()->get('rtl') == 1): ?> dir="rtl" <?php endif; ?> />
<head>
	<meta charset="UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title><?php echo e(config('basic.site_title')); ?></title>

	<?php echo $__env->make('partials.seo', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

	<link rel="shortcut icon" href="<?php echo e(getFile(config('basic.default_file_driver'),config('basic.favicon_image'))); ?>"
		  type="image/x-icon">

	<link rel="stylesheet" href="<?php echo e(asset($themeTrue . 'css/all.min.css')); ?>"/>
	<link rel="stylesheet" href="<?php echo e(asset($themeTrue . 'css/fontawesome.min.css')); ?>"/>
	<link rel="stylesheet" href="<?php echo e(asset($themeTrue . 'css/bootstrap.min.css')); ?>"/>

	<link rel="stylesheet" href="<?php echo e(asset($themeTrue . 'css/owl.carousel.min.css')); ?>"/>
	<link rel="stylesheet" href="<?php echo e(asset($themeTrue . 'css/owl.theme.default.min.css')); ?>"/>

	<link rel="stylesheet" href="<?php echo e(asset($themeTrue . 'css/slick.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset($themeTrue . 'css/slick-theme.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset($themeTrue . 'css/select2.min.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset($themeTrue . 'css/nouislider.min.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset($themeTrue . 'css/fancybox.css')); ?>">

	<!-- Style_Css_link -->
	<link rel="stylesheet" href="<?php echo e(asset($themeTrue . 'css/style.css')); ?>"/>
	<?php echo $__env->yieldPushContent('css-lib'); ?>
	<?php echo $__env->yieldPushContent('style'); ?>

</head>
<body onload="preloder_function()" class="">

<!-- Preloader section start -->
<div id="preloader">
	<div class="phone">
		<span class="loader"></span>
		<span class="text"><?php echo app('translator')->get('Loading'); ?>...</span>
	</div>
</div>
<!-- Preloader section end -->

<?php echo $__env->make($theme.'partials.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make($theme.'partials.mobileNav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make($theme.'partials.banner', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->yieldContent('content'); ?>

<?php echo $__env->make($theme.'partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<script src="<?php echo e(asset($themeTrue . 'js/bootstrap.bundle.min.js')); ?>"></script>

<script src="<?php echo e(asset('assets/global/js/jquery.min.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue . 'js/owl.carousel.min.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue . 'js/swiper-bundle.min.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue . 'js/slick.min.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue . 'js/select2.min.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue . 'js/nouislider.min.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue . 'js/fancybox.umd.js')); ?>"></script>

<?php echo $__env->yieldPushContent('extra-js'); ?>
<script src="<?php echo e(asset($themeTrue . 'js/main.js')); ?>"></script>

<script src="<?php echo e(asset('assets/global/js/notiflix-aio-2.7.0.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/global/js/pusher.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/global/js/vue.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/global/js/axios.min.js')); ?>"></script>
<?php echo $__env->yieldContent('scripts'); ?>

<?php echo $__env->yieldPushContent('script'); ?>
<?php echo $__env->make($theme.'partials.notification', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->make('plugins', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
</html>
<?php /**PATH D:\server\htdocs\billpay\project\resources\views/themes/basic/layouts/app.blade.php ENDPATH**/ ?>